#ifndef ADDITIVE_METRICS_H
#define ADDITIVE_METRICS_H
#include <boost/functional/hash.hpp>
#include <functional>
#include <tuple>

// struct AdditiveMetrics {
//     virtual AdditiveMetrics operator+(AdditiveMetrics &other) const = 0;
//     virtual bool operator==(AdditiveMetrics &other) const = 0;
//     virtual ~AdditiveMetrics();
// };

// C++ language made that initializing to be rather difficult (as I would like
// to call summary before getting back the trues below.) Thus, I don't have
// const for stuff below const below
struct Objective {
    Objective(){};
    Objective(const int falses, const int regularization);

    int falses;
    int regularization;
    float objective;

    Objective operator+(const Objective &other) const {
        return Objective(falses + other.falses,
                         regularization + other.regularization);
    }
    
    std::tuple<float, int, int> to_tuple() const {
        return std::make_tuple(objective, falses, regularization);
    }

    bool operator==(const Objective &other) const {
        return objective == other.objective;
    }

    bool operator<(const Objective &other) const {
        return objective < other.objective;
    }

    bool operator<(const float &other) const {
        return objective < other;
    }
    bool operator<=(const float &other) const {
        return objective <= other;
    }
    bool operator>(const float &other) const {
        return objective > other;
    }
    bool operator>=(const float &other) const {
        return objective >= other;
    }

};

struct ValuesOfInterest {
    ValuesOfInterest(){};
    ValuesOfInterest(const int TP, const int TN, const int regularization)
        : TP(TP), TN(TN), regularization(regularization){};

    int TP;
    int TN;
    int regularization;

    ValuesOfInterest operator+(const ValuesOfInterest &other) const {
        return ValuesOfInterest(TP + other.TP, TN + other.TN,
                                regularization + other.regularization);
    }

    bool operator==(const ValuesOfInterest &other) const {
        return TP == other.TP && TN == other.TN && regularization == other.regularization;
    }
    
    
    size_t hash() const {
        size_t result = 0;
        boost::hash_combine(result, TP);
        boost::hash_combine(result, TN);
        boost::hash_combine(result, regularization);
        return result;
    }

    std::tuple<int, int, int> to_tuple() const {
        return std::make_tuple(TP, TN, regularization);
    }
};

struct ObjectiveHash {
    std::size_t operator()(const Objective &k) const {
        return std::hash<float>{}(k.objective);
    }
};

struct ObjectiveLess {
    bool operator()(const Objective &left, const Objective &right) const {
        return left.objective < right.objective;
    }
};
#endif